package com.java24hours;

import java.io.*;
import java.util.*;

public class Configurator {

    public Configurator() {
        try {
            // Wczytaj plik konfiguracyjny
            File configFile = new File("program.properties");
            FileInputStream inStream = new FileInputStream(configFile);
            Properties config = new Properties();
            config.load(inStream);
            // Utwórz nową właściwość
            Date current = new Date();
            config.setProperty("runtime", current.toString());
            // Zapisz plik konfiguracyjny
            FileOutputStream outStream = new FileOutputStream(configFile);
            config.store(outStream, "Ustawienia konfiguracyjne");
            inStream.close();
            config.list(System.out);
        } catch (IOException ioe) {
            System.out.println("Błąd we-wy " + ioe.getMessage());
        }
    }

    public static void main(String[] arguments) {
        new Configurator();
    }
}